# Copyright 2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.2

EAPI=8

CRATES="
	addr2line@0.24.2
	adler2@2.0.1
	aead@0.5.2
	aes-gcm@0.10.3
	aes@0.8.4
	aho-corasick@1.1.3
	android_system_properties@0.1.5
	anstream@0.6.19
	anstyle-parse@0.2.7
	anstyle-query@1.1.3
	anstyle-wincon@3.0.9
	anstyle@1.0.11
	anyhow@1.0.98
	arraydeque@0.5.1
	arrayvec@0.7.6
	ashpd@0.11.0
	asn1-rs-derive@0.5.1
	asn1-rs-impl@0.2.0
	asn1-rs@0.6.2
	async-broadcast@0.7.2
	async-channel@2.5.0
	async-recursion@1.1.1
	async-trait@0.1.88
	autocfg@1.5.0
	backtrace@0.3.75
	base16ct@0.2.0
	base64@0.22.1
	base64ct@1.8.0
	bincode@1.3.3
	bitflags@1.3.2
	bitflags@2.9.1
	block-buffer@0.10.4
	block-padding@0.3.3
	bumpalo@3.19.0
	byteorder@1.5.0
	bytes@1.10.1
	cairo-rs@0.20.12
	cairo-sys-rs@0.20.10
	camino@1.1.10
	cargo-platform@0.2.0
	cargo-util-schemas@0.2.0
	cargo_metadata@0.20.0
	cbc@0.1.2
	cc@1.2.30
	ccm@0.5.0
	cfg-expr@0.20.1
	cfg-if@1.0.1
	cfg_aliases@0.2.1
	cipher@0.4.4
	clap@4.5.42
	clap_builder@4.5.42
	clap_derive@4.5.41
	clap_lex@0.7.5
	colorchoice@1.0.4
	concurrent-queue@2.5.0
	const-oid@0.9.6
	const_format@0.2.34
	const_format_proc_macros@0.2.34
	core-foundation-sys@0.8.7
	core-foundation@0.10.1
	core-graphics-types@0.2.0
	core-graphics@0.25.0
	cpufeatures@0.2.17
	critical-section@1.2.0
	crossbeam-channel@0.5.15
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.21
	crypto-bigint@0.5.5
	crypto-common@0.1.6
	ctr@0.9.2
	curve25519-dalek-derive@0.1.1
	curve25519-dalek@4.1.3
	data-encoding@2.9.0
	der-parser@9.0.0
	der@0.7.10
	deranged@0.4.0
	digest@0.10.7
	displaydoc@0.2.5
	downcast-rs@1.2.1
	ecdsa@0.16.9
	elliptic-curve@0.13.8
	endi@1.1.0
	enum-as-inner@0.6.1
	enumflags2@0.7.12
	enumflags2_derive@0.7.12
	env_filter@0.1.3
	env_logger@0.11.8
	equivalent@1.0.2
	erased-serde@0.4.6
	errno@0.3.13
	event-listener-strategy@0.5.4
	event-listener@5.4.0
	fastrand@2.3.0
	ff@0.13.1
	fiat-crypto@0.2.9
	field-offset@0.3.6
	foreign-types-macros@0.2.3
	foreign-types-shared@0.3.1
	foreign-types@0.5.0
	form_urlencoded@1.2.1
	futures-channel@0.3.31
	futures-core@0.3.31
	futures-executor@0.3.31
	futures-io@0.3.31
	futures-lite@2.6.0
	futures-macro@0.3.31
	futures-sink@0.3.31
	futures-task@0.3.31
	futures-util@0.3.31
	futures@0.3.31
	gdk-pixbuf-sys@0.20.10
	gdk-pixbuf@0.20.10
	gdk4-sys@0.9.6
	gdk4@0.9.6
	generator@0.8.5
	generic-array@0.14.7
	getrandom@0.2.16
	getrandom@0.3.3
	ghash@0.5.1
	gimli@0.31.1
	gio-sys@0.20.10
	gio@0.20.12
	git2@0.20.2
	glib-build-tools@0.20.0
	glib-macros@0.20.12
	glib-sys@0.20.10
	glib@0.20.12
	gobject-sys@0.20.10
	graphene-rs@0.20.10
	graphene-sys@0.20.10
	group@0.13.0
	gsk4-sys@0.9.6
	gsk4@0.9.6
	gtk4-macros@0.9.5
	gtk4-sys@0.9.6
	gtk4@0.9.7
	hashbrown@0.15.4
	heck@0.5.0
	hex@0.4.3
	hickory-proto@0.25.2
	hickory-resolver@0.25.2
	hkdf@0.12.4
	hmac@0.12.1
	hostname@0.4.1
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.63
	icu_collections@2.0.0
	icu_locale_core@2.0.0
	icu_normalizer@2.0.0
	icu_normalizer_data@2.0.0
	icu_properties@2.0.1
	icu_properties_data@2.0.1
	icu_provider@2.0.0
	idna@1.0.3
	idna_adapter@1.2.1
	indexmap@2.10.0
	inout@0.1.4
	io-uring@0.7.9
	ipconfig@0.3.2
	ipnet@2.11.0
	is_debug@1.1.0
	is_terminal_polyfill@1.70.1
	itoa@1.0.15
	jiff-static@0.2.15
	jiff@0.2.15
	jobserver@0.1.33
	js-sys@0.3.77
	keycode@1.0.0
	keycode_macro@1.0.0
	lazy_static@1.5.0
	libadwaita-sys@0.7.2
	libadwaita@0.7.2
	libc@0.2.174
	libgit2-sys@0.18.2+1.9.1
	libz-sys@1.1.22
	linux-raw-sys@0.4.15
	linux-raw-sys@0.9.4
	litemap@0.8.0
	local-channel@0.1.5
	local-waker@0.1.4
	lock_api@0.4.13
	log@0.4.27
	loom@0.7.2
	matchers@0.1.0
	memchr@2.7.5
	memmap@0.7.0
	memoffset@0.7.1
	memoffset@0.9.1
	minimal-lexical@0.2.1
	miniz_oxide@0.8.9
	mio@1.0.4
	moka@0.12.10
	nix@0.26.4
	nix@0.30.1
	nom@7.1.3
	nu-ansi-term@0.46.0
	num-bigint@0.4.6
	num-conv@0.1.0
	num-integer@0.1.46
	num-traits@0.2.19
	num_enum@0.7.4
	num_enum_derive@0.7.4
	num_threads@0.1.7
	object@0.36.7
	oid-registry@0.7.1
	once_cell@1.21.3
	once_cell_polyfill@1.70.1
	opaque-debug@0.3.1
	ordered-float@2.10.1
	ordered-stream@0.2.0
	overload@0.1.1
	p256@0.13.2
	p384@0.13.1
	pango-sys@0.20.10
	pango@0.20.12
	parking@2.2.1
	parking_lot@0.12.4
	parking_lot_core@0.9.11
	paste@1.0.15
	pem-rfc7468@0.7.0
	pem@3.0.5
	percent-encoding@2.3.1
	pin-project-lite@0.2.16
	pin-utils@0.1.0
	pkcs8@0.10.2
	pkg-config@0.3.32
	polyval@0.6.2
	portable-atomic-util@0.2.4
	portable-atomic@1.11.1
	potential_utf@0.1.2
	powerfmt@0.2.0
	ppv-lite86@0.2.21
	primeorder@0.13.6
	proc-macro-crate@3.3.0
	proc-macro2@1.0.95
	quick-xml@0.37.5
	quote@1.0.40
	r-efi@5.3.0
	rand@0.8.5
	rand@0.9.2
	rand_chacha@0.3.1
	rand_chacha@0.9.0
	rand_core@0.6.4
	rand_core@0.9.3
	rcgen@0.13.2
	redox_syscall@0.5.17
	regex-automata@0.1.10
	regex-automata@0.4.9
	regex-syntax@0.6.29
	regex-syntax@0.8.5
	regex@1.11.1
	reis@0.5.0
	resolv-conf@0.7.4
	rfc6979@0.4.0
	ring@0.17.14
	rustc-demangle@0.1.26
	rustc_version@0.4.1
	rusticata-macros@4.1.0
	rustix@0.38.44
	rustix@1.0.8
	rustls-pki-types@1.12.0
	rustls-webpki@0.103.4
	rustls@0.23.31
	rustversion@1.0.21
	ryu@1.0.20
	scoped-tls@1.0.1
	scopeguard@1.2.0
	sec1@0.7.3
	semver@1.0.26
	serde-untagged@0.1.7
	serde-value@0.7.0
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.141
	serde_repr@0.1.20
	serde_spanned@0.6.9
	sha1@0.10.6
	sha2@0.10.9
	shadow-rs@1.2.0
	sharded-slab@0.1.7
	shlex@1.3.0
	signal-hook-registry@1.4.5
	signature@2.2.0
	slab@0.4.10
	smallvec@1.15.1
	socket2@0.5.10
	socket2@0.6.0
	spki@0.7.3
	stable_deref_trait@1.2.0
	static_assertions@1.1.0
	strsim@0.11.1
	subtle@2.6.1
	syn@2.0.104
	synstructure@0.13.2
	system-deps@7.0.5
	tagptr@0.2.0
	target-lexicon@0.13.2
	tempfile@3.20.0
	thiserror-impl@1.0.69
	thiserror-impl@2.0.12
	thiserror@1.0.69
	thiserror@2.0.12
	thread_local@1.1.9
	time-core@0.1.4
	time-macros@0.2.22
	time@0.3.41
	tinystr@0.8.1
	tinyvec@1.9.0
	tinyvec_macros@0.1.1
	tokio-macros@2.5.0
	tokio-stream@0.1.17
	tokio-util@0.7.15
	tokio@1.47.0
	toml@0.8.23
	toml_datetime@0.6.11
	toml_edit@0.22.27
	toml_write@0.1.2
	tracing-attributes@0.1.30
	tracing-core@0.1.34
	tracing-log@0.2.0
	tracing-subscriber@0.3.19
	tracing@0.1.41
	typeid@1.0.3
	typenum@1.18.0
	tz-rs@0.7.0
	tzdb@0.7.2
	tzdb_data@0.2.2
	uds_windows@1.1.0
	unicode-ident@1.0.18
	unicode-xid@0.2.6
	universal-hash@0.5.1
	untrusted@0.9.0
	url@2.5.4
	utf8_iter@1.0.4
	utf8parse@0.2.2
	uuid@1.17.0
	valuable@0.1.1
	vcpkg@0.2.15
	version-compare@0.2.0
	version_check@0.9.5
	wasi@0.11.1+wasi-snapshot-preview1
	wasi@0.14.2+wasi-0.2.4
	wasm-bindgen-backend@0.2.100
	wasm-bindgen-macro-support@0.2.100
	wasm-bindgen-macro@0.2.100
	wasm-bindgen-shared@0.2.100
	wasm-bindgen@0.2.100
	wayland-backend@0.3.11
	wayland-client@0.31.11
	wayland-protocols-misc@0.3.9
	wayland-protocols-wlr@0.3.9
	wayland-protocols@0.32.9
	wayland-scanner@0.31.7
	wayland-sys@0.31.7
	webrtc-dtls@0.12.0
	webrtc-util@0.11.0
	widestring@1.2.0
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-collections@0.2.0
	windows-core@0.61.2
	windows-future@0.2.1
	windows-implement@0.60.0
	windows-interface@0.59.1
	windows-link@0.1.3
	windows-numerics@0.2.0
	windows-result@0.3.4
	windows-strings@0.4.2
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-sys@0.60.2
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows-targets@0.53.3
	windows-threading@0.1.0
	windows@0.61.3
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.52.6
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	windows_x86_64_msvc@0.53.0
	winnow@0.7.12
	winreg@0.50.0
	wit-bindgen-rt@0.39.0
	writeable@0.6.1
	x11@2.21.0
	x25519-dalek@2.0.1
	x509-parser@0.16.0
	yasna@0.5.2
	yoke-derive@0.8.0
	yoke@0.8.0
	zbus@5.9.0
	zbus_macros@5.9.0
	zbus_names@4.2.0
	zerocopy-derive@0.8.26
	zerocopy@0.8.26
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zeroize@1.8.1
	zeroize_derive@1.4.2
	zerotrie@0.2.2
	zerovec-derive@0.11.1
	zerovec@0.11.2
	zvariant@5.6.0
	zvariant_derive@5.6.0
	zvariant_utils@3.2.0
"

RUST_MIN_VER="1.85.0"

inherit cargo desktop systemd xdg

DEPEND="
	dev-libs/glib:2
	gui-libs/gtk:4
	gui-libs/libadwaita:1
	x11-libs/libX11
	x11-libs/libXtst
	x11-themes/hicolor-icon-theme
	debug? (
		x11-libs/cairo
		x11-libs/pango
		x11-libs/gdk-pixbuf:2
		media-libs/graphene
		dev-libs/libgit2:=
	)
"
RDEPEND="${DEPEND}"
BDEPEND="virtual/pkgconfig"

DESCRIPTION="Software KVM Switch / mouse & keyboard sharing software for Local Area Networks"
HOMEPAGE="https://github.com/feschber/lan-mouse"

COMMIT=4e5a66340a224910e56bf49bc11d2ad804dc6773
SRC_URI="
	${CARGO_CRATE_URIS}
	https://github.com/feschber/lan-mouse/archive/$COMMIT.tar.gz -> ${P}.tar.gz
"
S="${WORKDIR}/${PN}-$COMMIT"

LICENSE="GPL-3+"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD ISC MIT Unicode-3.0
	ZLIB
"
SLOT="0"
KEYWORDS="~amd64"

RESTRICT="mirror"

QA_FLAGS_IGNORED="usr/bin/lan-mouse"

src_install() {
	cargo_src_install
	doicon -s scalable lan-mouse-gtk/resources/de.feschber.LanMouse.svg
	domenu de.feschber.LanMouse.desktop
	systemd_douserunit service/lan-mouse.service
}
