# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	adler2@2.0.1
	ahash@0.8.12
	anstream@0.6.20
	anstyle-parse@0.2.7
	anstyle-query@1.1.4
	anstyle-wincon@3.0.10
	anstyle@1.0.11
	arrayref@0.3.9
	arrayvec@0.7.6
	assert_cmd@2.0.17
	autocfg@1.5.0
	av-data@0.4.4
	base64@0.22.1
	bit_field@0.10.3
	bitflags@1.3.2
	bitflags@2.9.4
	bitreader@0.3.11
	bstr@1.12.0
	byte-slice-cast@1.2.3
	bytemuck@1.23.2
	byteorder-lite@0.1.0
	byteorder@1.5.0
	bytes@1.10.1
	cfg-expr@0.20.3
	cfg-if@1.0.3
	clap@4.5.48
	clap_builder@4.5.48
	clap_complete@4.5.58
	clap_derive@4.5.47
	clap_lex@0.7.5
	color_quant@1.1.0
	colorchoice@1.0.4
	core_maths@0.1.1
	crc32fast@1.5.0
	crossbeam-deque@0.8.6
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.21
	crunchy@0.2.4
	data-url@0.3.2
	dav1d-sys@0.8.3
	dav1d@0.10.4
	difflib@0.4.0
	doc-comment@0.3.3
	document-features@0.2.11
	equivalent@1.0.2
	errno@0.3.14
	euclid@0.22.11
	exr@1.73.0
	fallible_collections@0.4.9
	fast_image_resize@5.3.0
	fastrand@2.3.0
	fax@0.2.6
	fax_derive@0.2.0
	fdeflate@0.3.7
	flate2@1.1.2
	float-cmp@0.9.0
	fontconfig-parser@0.5.8
	fontdb@0.23.0
	gif@0.13.3
	half@2.6.0
	hashbrown@0.13.2
	hashbrown@0.16.0
	heck@0.5.0
	image-webp@0.2.4
	image@0.25.8
	imagesize@0.13.0
	indexmap@2.11.4
	is_terminal_polyfill@1.70.1
	keyframe@1.1.1
	kurbo@0.11.3
	lebe@0.5.3
	libc@0.2.175
	libm@0.2.15
	linux-raw-sys@0.11.0
	litrs@0.4.2
	log@0.4.28
	memchr@2.7.5
	memmap2@0.9.8
	miniz_oxide@0.8.9
	mint@0.5.9
	moxcms@0.7.5
	mp4parse@0.17.0
	num-bigint@0.4.6
	num-derive@0.4.2
	num-integer@0.1.46
	num-rational@0.4.2
	num-traits@0.2.19
	once_cell@1.21.3
	once_cell_polyfill@1.70.1
	pico-args@0.5.0
	pkg-config@0.3.32
	png@0.17.16
	png@0.18.0
	predicates-core@1.0.9
	predicates-tree@1.0.12
	predicates@3.1.3
	proc-macro2@1.0.101
	pxfm@0.1.24
	qoi@0.4.1
	quick-error@2.0.1
	quick-xml@0.38.3
	quote@1.0.40
	rayon-core@1.13.0
	regex-automata@0.4.10
	resvg@0.45.1
	rgb@0.8.52
	roxmltree@0.20.0
	rustix@1.1.2
	rustybuzz@0.20.1
	sd-notify@0.4.5
	serde@1.0.225
	serde_core@1.0.225
	serde_derive@1.0.225
	serde_spanned@0.6.9
	simd-adler32@0.3.7
	simplecss@0.2.2
	siphasher@1.0.1
	slotmap@1.0.7
	smallvec@1.15.1
	static_assertions@1.1.0
	strict-num@0.1.1
	strsim@0.11.1
	svgtypes@0.15.3
	syn@2.0.106
	system-deps@7.0.5
	target-lexicon@0.13.2
	terminal_size@0.4.3
	termtree@0.5.1
	thiserror-impl@2.0.16
	thiserror@2.0.16
	tiff@0.10.3
	tiny-bench@0.4.0
	tiny-skia-path@0.11.4
	tiny-skia@0.11.4
	tinyvec@1.10.0
	tinyvec_macros@0.1.1
	toml@0.8.23
	toml_datetime@0.6.11
	toml_edit@0.22.27
	ttf-parser@0.25.1
	unicode-bidi-mirroring@0.4.0
	unicode-bidi@0.3.18
	unicode-ccc@0.4.0
	unicode-ident@1.0.19
	unicode-properties@0.1.3
	unicode-script@0.5.7
	unicode-vo@0.1.0
	usvg@0.45.1
	utf8parse@0.2.2
	version-compare@0.2.0
	version_check@0.9.5
	wait-timeout@0.2.1
	waybackend-scanner@0.6.2
	waybackend@0.6.2
	weezl@0.1.10
	windows-link@0.1.3
	windows-link@0.2.0
	windows-sys@0.60.2
	windows-sys@0.61.0
	windows-targets@0.53.3
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.53.0
	winnow@0.7.13
	xmlwriter@0.1.0
	zerocopy-derive@0.8.27
	zerocopy@0.8.27
	zune-core@0.4.12
	zune-inflate@0.2.54
	zune-jpeg@0.4.21
"

inherit cargo shell-completion

DESCRIPTION="Efficient animated wallpaper daemon for wayland, controlled at runtime"
HOMEPAGE="https://codeberg.org/LGFae/awww"
if [[ ${PV} == *9999* ]]; then
	inherit git-r3
	EGIT_REPO_URI="https://codeberg.org/LGFae/${PN}.git"
else
	SRC_URI="
	https://codeberg.org/LGFae/${PN}/archive/refs/tags/v${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
	"
	KEYWORDS="~amd64"
fi

S="${WORKDIR}/${PN}"

LICENSE="GPL-3"
# Dependent crate licenses
LICENSE+="
	Apache-2.0-with-LLVM-exceptions BSD-2 BSD MIT MPL-2.0 Unicode-3.0
	ZLIB
"
SLOT="0"
RUST_MIN_VER="1.89.0"

DEPEND="
	app-arch/lz4:=
	x11-libs/libxkbcommon[wayland]
"
RDEPEND="${DEPEND}"
BDEPEND="
	app-text/scdoc
"

QA_FLAGS_IGNORED="
	usr/bin/swww
	usr/bin/swww-daemon
"

src_unpack() {
	if [[ "${PV}" == *9999* ]]; then
		git-r3_src_unpack
		cargo_live_src_unpack
	else
		cargo_src_unpack
	fi
}

src_compile() {
	cargo_src_compile
	./doc/gen.sh || die # generate man pages
}

src_install() {
	dobin "$(cargo_target_dir)"/swww{,-daemon}
	dosym swww /usr/bin/${PN}
	dosym swww-daemon /usr/bin/${PN}-daemon

	doman doc/generated/*.1

	dodoc README.md CHANGELOG.md
	newbashcomp completions/swww.bash swww
	dofishcomp completions/swww.fish
	dozshcomp completions/_swww
}

pkg_postinst() {
	ewarn "The project has been renamed from swww to awww"
	ewarn "This ebuild installs symlinks to ease the transition"
}
